dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 220, 250, "assets/images/table/island_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 4, 255, 400, "assets/images/table/island", "assets/images/food/item_mark2", "B" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 1;
numServers = 1;
maxCoupleHappiness = 300;

-- Group 1
guest = LManager.GenGuest(uncle);
guest.matchType = male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table1;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2


guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 6, 20000);

-- Group 3

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 38000);

-- Group 3

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestTissue = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 12, 65000);


-- Group 4

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(13, 14, 90000);

-- Group 5

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 18, 120000);


LManager:AdjustGuestTolerance(130);



LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);


LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 100000 );

-- Set up the Level Settings
LManager:SetLevelNumber(4,1);
LManager:SetLevelScores(7000, 9500);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/new_dance_1.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );